# -*- coding: utf-8 -*-
# Generated by Django 1.10.1 on 2017-03-22 14:53
import django.db.models.deletion

from django.db import migrations, models

import django.contrib.postgres.fields.jsonb
import django.contrib.postgres.search
from ..models import IndexEntry


table = IndexEntry._meta.db_table


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='IndexEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.TextField()),
                ('body_search', django.contrib.postgres.search.SearchVectorField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name_plural': 'index entries',
                'verbose_name': 'index entry',
            },
        ),
        migrations.AlterUniqueTogether(
            name='indexentry',
            unique_together=set([('content_type', 'object_id')]),
        ),
        migrations.RunSQL(
            'CREATE INDEX {0}_body_search ON {0} '
            'USING GIN(body_search);'.format(table),
            'DROP INDEX {}_body_search;'.format(table),
        ),
    ]
