from django.contrib import admin
from .models import *

def set_product_online(modeladmin, request, queryset):
    queryset.update(status=1)
set_product_online.short_description = "Mettre en ligne"

class ProductItemAdmin(admin.TabularInline):
    model = ProductItem
    raw_id_fields = ["attributes"]

class ProductAdmin(admin.ModelAdmin):
    model = Product
    inlines = [ProductItemAdmin,]
    date_hierarchy = 'date_creation'
    ordering = ('-date_creation',)
    actions = [set_product_online]
    search_fields = ('name', 'status')
    list_filter = ('status', 'date_creation')
    radio_fields = {"status": admin.VERTICAL}
    list_display = ["id", "name", "price_ht", "price_ttc", "code", "date_creation"]
#    list_editable = ["name", "price_ht", "price_ttc"]

admin.site.register(Product, ProductAdmin)
admin.site.register(ProductItem)
admin.site.register(ProductAttribute)
admin.site.register(ProductAttributeValue)