from django.db import models
import django.utils.timezone

# Create your models here.

class Liste_des_Exercices(models.Model):
    Annee = models.IntegerField(default=0)
    DateDebut = models.DateField()
    DateFin = models.DateField()
    Cloturer = models.BooleanField(default=False)
    Date_creation = models.DateTimeField(default=django.utils.timezone.now, blank=True, verbose_name="Date de création")

    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name_plural = "Liste des Exercices"

class Liste_des_Periodes(models.Model):
    Annee = models.ForeignKey(Liste_des_Exercices, on_delete=models.CASCADE)
    DateDebut = models.DateField()
    DateFin = models.DateField()
    Cloturer = models.BooleanField(default=False)
    Date_creation = models.DateTimeField(default=django.utils.timezone.now, blank=True, verbose_name="Date de création")

    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name_plural = "Gestion des Périodes"

class Liste_des_Taxes(models.Model):
    CodeTaxe = models.CharField(max_length=100)
    Taux = models.IntegerField()
    Date_creation = models.DateTimeField(default=django.utils.timezone.now, blank=True, verbose_name="Date de création")

    def __unicode__(self):
        return self.CodeTaxe

    class Meta:
        verbose_name_plural = "Liste des Taxes"