#Ici on déclare les imports des biblios
import folium

#Ici c'est l'initialisation de la carte
ma_carte = folium.Map(
    location=[45.372, -121.6972],
    zoom_start=12,
    tiles='Stamen Terrain'
)

tooltip = 'Click me!'

#Ici on ajoute des marqueurs
folium.Marker(
    location=[45.3288, -121.6625],
    popup='Mt. Hood Meadows',
    icon=folium.Icon(icon='cloud')
).add_to(ma_carte)

folium.Marker(
    location=[45.3311, -121.7113],
    popup='Timberline Lodge',
    icon=folium.Icon(color='green')
).add_to(ma_carte)

folium.Marker(
    location=[45.3300, -121.6823],
    popup='Some Other Location',
    icon=folium.Icon(color='red', icon='info-sign')
).add_to(ma_carte)

#Ici on ajoute un cercle
folium.Circle(
    radius=100,
    location=[45.3288, -121.6625],
    popup='The Waterfront',
    color='crimson',
    fill=False,
).add_to(ma_carte)

#Ici on ajoute un cercle avec couleur de fond
folium.CircleMarker(
    location=[45.3300, -121.6823],
    radius=50,
    popup='Laurelhurst Park',
    color='#3186cc',
    fill=True,
    fill_color='#3186cc'
).add_to(ma_carte)

#Ici c'est la dernière ligne NE RIEN METTRE APRES
ma_carte.save('index.html')