# -*- coding: utf-8 -*-
# Generated by Django 1.11.5 on 2017-10-19 14:53
from __future__ import unicode_literals

import django.contrib.postgres.search
from django.db import migrations

from ..models import IndexEntry


table = IndexEntry._meta.db_table


class Migration(migrations.Migration):

    dependencies = [
        ('postgres_search', '0001_initial'),
    ]

    operations = [
        migrations.RunSQL(
            'DROP INDEX {}_body_search;'.format(table),
            'CREATE INDEX {0}_body_search ON {0} '
            'USING GIN(body_search);'.format(table),
        ),
        migrations.RenameField(
            model_name='indexentry',
            old_name='body_search',
            new_name='body',
        ),
        migrations.AddField(
            model_name='indexentry',
            name='autocomplete',
            field=django.contrib.postgres.search.SearchVectorField(default=''),
            preserve_default=False,
        ),
        migrations.AddIndex(
            model_name='indexentry',
            index=django.contrib.postgres.indexes.GinIndex(
                fields=['autocomplete'],
                name='postgres_se_autocom_ee48c8_gin'),
        ),
        migrations.AddIndex(
            model_name='indexentry',
            index=django.contrib.postgres.indexes.GinIndex(
                fields=['body'],
                name='postgres_se_body_aaaa99_gin'),
        ),
    ]
