# Generated by Django 2.1.7 on 2019-03-20 18:31

import datetime
from django.db import migrations, models
import django.db.models.deletion
from django.utils.timezone import utc


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('code', models.CharField(blank=True, max_length=10, null=True, unique=True)),
                ('price_ht', models.DecimalField(decimal_places=2, max_digits=8, verbose_name='Prix unitaire HT')),
                ('price_ttc', models.DecimalField(decimal_places=2, max_digits=8, verbose_name='Prix unitaire TTC')),
                ('status', models.SmallIntegerField(choices=[(0, 'Offline'), (1, 'Online'), (2, 'Out of stock')], default=0)),
                ('date_creation', models.DateTimeField(blank=True, default=datetime.datetime(2019, 3, 20, 18, 31, 3, 122089, tzinfo=utc), verbose_name='Date création')),
            ],
            options={
                'verbose_name': 'Produit',
            },
        ),
        migrations.CreateModel(
            name='ProductAttribute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'verbose_name': 'Attribut',
            },
        ),
        migrations.CreateModel(
            name='ProductAttributeValue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=100)),
                ('position', models.PositiveSmallIntegerField(blank=True, null=True, verbose_name='Position')),
                ('product_attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Commercial.ProductAttribute', verbose_name='Unité')),
            ],
            options={
                'verbose_name': 'Valeur attribut',
                'ordering': ['position'],
            },
        ),
        migrations.CreateModel(
            name='ProductItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, max_length=10, null=True, unique=True)),
                ('code_ean13', models.CharField(max_length=13)),
                ('attributes', models.ManyToManyField(blank=True, null=True, related_name='product_item', to='Commercial.ProductAttributeValue')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='product_item', to='Commercial.Product')),
            ],
            options={
                'verbose_name': 'Déclinaison Produit',
            },
        ),
    ]
