-- Script gnr par WinDev le 15/07/2013 15:07:21
-- Tables de l'analyse OGS.wda
-- pour SQL Server

-- Cration de la table Affectations
CREATE TABLE [Affectations] (
    [IDAffectations] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [NomChantier] VARCHAR(70) ,
    [Affectation] VARCHAR(50) );
CREATE INDEX [WDIDX_Affectations_CodeChantier] ON [Affectations] ([CodeChantier]);
CREATE INDEX [WDIDX_Affectations_NomChantier] ON [Affectations] ([NomChantier]);
CREATE INDEX [WDIDX_Affectations_Affectation] ON [Affectations] ([Affectation]);

-- Cration de la table Articles
CREATE TABLE [Articles] (
    [IDArticles] INTEGER  IDENTITY   PRIMARY KEY ,
    [Designation] VARCHAR(100) ,
    [Description] VARCHAR(100) ,
    [CodeSage] VARCHAR(50) ,
    [StatutObjet] SMALLINT DEFAULT 0,
    [Usage] SMALLINT DEFAULT 0,
    [Marque] VARCHAR(50) ,
    [Unite] VARCHAR(50) ,
    [Stockable] SMALLINT DEFAULT 0,
    [AffectComptable] VARCHAR(50) ,
    [Alternatif1] VARCHAR(50) ,
    [CodeArticle] VARCHAR(6) DEFAULT '0',
    [Alternatif2] VARCHAR(50) ,
    [Alternatif3] VARCHAR(50) ,
    [CodeLien] VARCHAR(8) ,
    [PheonetiqueDes] VARCHAR(50) );
CREATE INDEX [WDIDX_Articles_Designation] ON [Articles] ([Designation]);
CREATE INDEX [WDIDX_Articles_CodeSage] ON [Articles] ([CodeSage]);
CREATE INDEX [WDIDX_Articles_StatutObjet] ON [Articles] ([StatutObjet]);
CREATE INDEX [WDIDX_Articles_Marque] ON [Articles] ([Marque]);
CREATE INDEX [WDIDX_Articles_Unite] ON [Articles] ([Unite]);
CREATE INDEX [WDIDX_Articles_Stockable] ON [Articles] ([Stockable]);
CREATE INDEX [WDIDX_Articles_Alternatif1] ON [Articles] ([Alternatif1]);
CREATE INDEX [WDIDX_Articles_CodeArticle] ON [Articles] ([CodeArticle]);
CREATE INDEX [WDIDX_Articles_Alternatif2] ON [Articles] ([Alternatif2]);
CREATE INDEX [WDIDX_Articles_Alternatif3] ON [Articles] ([Alternatif3]);
CREATE INDEX [WDIDX_Articles_CodeLien] ON [Articles] ([CodeLien]);
CREATE INDEX [WDIDX_Articles_PheonetiqueDes] ON [Articles] ([PheonetiqueDes]);
CREATE INDEX [WDIDX_Articles_OptimCleComp_Statu_Pheon] ON [Articles] ([StatutObjet],[PheonetiqueDes]);
CREATE INDEX [WDIDX_Articles_OptimCleComp_CodeL_Statu] ON [Articles] ([CodeLien],[StatutObjet]);

-- Cration de la table Categories
CREATE TABLE [Categories] (
    [IDCategories] INTEGER  IDENTITY   PRIMARY KEY ,
    [Designation] VARCHAR(100) ,
    [CodeCategorie] VARCHAR(8)  UNIQUE  DEFAULT '0',
    [PheonetiqueDes] VARCHAR(50) );
CREATE INDEX [WDIDX_Categories_Designation] ON [Categories] ([Designation]);
CREATE INDEX [WDIDX_Categories_PheonetiqueDes] ON [Categories] ([PheonetiqueDes]);

-- Cration de la table Chantiers
CREATE TABLE [Chantiers] (
    [IDChantiers] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeChantier] VARCHAR(50)  UNIQUE  DEFAULT '0',
    [NomChantier] VARCHAR(70) ,
    [Adresse] VARCHAR(100) ,
    [CodeSection] INTEGER DEFAULT 0,
    [Periodicite] SMALLINT DEFAULT 0,
    [SectionAnalytique] VARCHAR(4) ,
    [DateImport] DATETIME );
CREATE INDEX [WDIDX_Chantiers_NomChantier] ON [Chantiers] ([NomChantier]);
CREATE INDEX [WDIDX_Chantiers_CodeSection] ON [Chantiers] ([CodeSection]);
CREATE INDEX [WDIDX_Chantiers_Periodicite] ON [Chantiers] ([Periodicite]);
CREATE INDEX [WDIDX_Chantiers_SectionAnalytique] ON [Chantiers] ([SectionAnalytique]);

-- Cration de la table Consignations
CREATE TABLE [Consignations] (
    [IDConsignations] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [CodeArticle] VARCHAR(6) ,
    [Article] VARCHAR(70) ,
    [Statut] SMALLINT DEFAULT 0,
    [Reference] VARCHAR(50) ,
    [NumBonPret] VARCHAR(50) ,
    [DateOperation] DATETIME ,
    [Demandeur] VARCHAR(50) ,
    [Precisions] VARCHAR(70) ,
    [DateRetourPret] DATETIME ,
    [NumBonRetour] VARCHAR(50) ,
    [EtatMateriel] SMALLINT DEFAULT 0,
    [CodeConsignation] SMALLINT DEFAULT 0,
    [Annee] DATETIME ,
    [Mois] DATETIME );
CREATE INDEX [WDIDX_Consignations_CodeChantier] ON [Consignations] ([CodeChantier]);
CREATE INDEX [WDIDX_Consignations_CodeArticle] ON [Consignations] ([CodeArticle]);
CREATE INDEX [WDIDX_Consignations_Article] ON [Consignations] ([Article]);
CREATE INDEX [WDIDX_Consignations_Statut] ON [Consignations] ([Statut]);
CREATE INDEX [WDIDX_Consignations_NumBonPret] ON [Consignations] ([NumBonPret]);
CREATE INDEX [WDIDX_Consignations_DateOperation] ON [Consignations] ([DateOperation]);
CREATE INDEX [WDIDX_Consignations_Demandeur] ON [Consignations] ([Demandeur]);
CREATE INDEX [WDIDX_Consignations_DateRetourPret] ON [Consignations] ([DateRetourPret]);
CREATE INDEX [WDIDX_Consignations_NumBonRetour] ON [Consignations] ([NumBonRetour]);
CREATE INDEX [WDIDX_Consignations_EtatMateriel] ON [Consignations] ([EtatMateriel]);
CREATE INDEX [WDIDX_Consignations_CodeConsignation] ON [Consignations] ([CodeConsignation]);
CREATE INDEX [WDIDX_Consignations_Annee] ON [Consignations] ([Annee]);
CREATE INDEX [WDIDX_Consignations_Mois] ON [Consignations] ([Mois]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_CodeC_CodeC_DateO] ON [Consignations] ([CodeConsignation],[CodeChantier],[DateOperation]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_EtatM_Etat] ON [Consignations] ([EtatMateriel],[Statut]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_Statu_EtatM] ON [Consignations] ([Statut],[EtatMateriel]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_CodeC_DateO] ON [Consignations] ([CodeChantier],[DateOperation]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_Artic_CodeC] ON [Consignations] ([Article],[CodeChantier]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_CodeA_CodeC] ON [Consignations] ([CodeArticle],[CodeChantier]);
CREATE INDEX [WDIDX_Consignations_OptimCleComp_Deman_CodeC] ON [Consignations] ([Demandeur],[CodeConsignation]);

-- Cration de la table Details_Mvts_Stock
CREATE TABLE [Details_Mvts_Stock] (
    [IDDetails_Mvts_Stock] INTEGER  IDENTITY   PRIMARY KEY ,
    [Affectation] VARCHAR(50) ,
    [Article] VARCHAR(70) ,
    [CodeArticle] VARCHAR(6) ,
    [Unite] VARCHAR(10) ,
    [Quantite] FLOAT DEFAULT 0,
    [Precisions] VARCHAR(70) ,
    [ImputationAnalyt] VARCHAR(50) ,
    [Consigne] BIT DEFAULT 0,
    [IDMvts_Stock] INTEGER ,
    [NomConforme] BIT DEFAULT 0,
    [PrixAchat] FLOAT DEFAULT 0);
CREATE INDEX [WDIDX_Details_Mvts_Stock_Affectation] ON [Details_Mvts_Stock] ([Affectation]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_Article] ON [Details_Mvts_Stock] ([Article]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_CodeArticle] ON [Details_Mvts_Stock] ([CodeArticle]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_Unite] ON [Details_Mvts_Stock] ([Unite]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_ImputationAnalyt] ON [Details_Mvts_Stock] ([ImputationAnalyt]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_Consigne] ON [Details_Mvts_Stock] ([Consigne]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_IDMvts_Stock] ON [Details_Mvts_Stock] ([IDMvts_Stock]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_NomConforme] ON [Details_Mvts_Stock] ([NomConforme]);
CREATE INDEX [WDIDX_Details_Mvts_Stock_AffectationCodeArticle] ON [Details_Mvts_Stock] ([Affectation],[CodeArticle]);

-- Cration de la table Familles
CREATE TABLE [Familles] (
    [IDFamilles] INTEGER  IDENTITY   PRIMARY KEY ,
    [Designation] VARCHAR(100) ,
    [CodeFamille] VARCHAR(2)  UNIQUE  DEFAULT '0');
CREATE INDEX [WDIDX_Familles_Designation] ON [Familles] ([Designation]);

-- Cration de la table Flux
CREATE TABLE [Flux] (
    [IDFlux] INTEGER  IDENTITY   PRIMARY KEY ,
    [RefFlux] VARCHAR(5) ,
    [Processus] SMALLINT DEFAULT 0,
    [Magasin] VARCHAR(50) ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [NumTransfert] VARCHAR(20) ,
    [DateOperation] DATETIME ,
    [NumLivraison] VARCHAR(20) ,
    [NumReception] VARCHAR(20) ,
    [NumCommande] VARCHAR(20) ,
    [ImputationAnalyt] VARCHAR(50) ,
    [NumSortie] VARCHAR(20) ,
    [CodeArticle] VARCHAR(6) ,
    [Quantite] FLOAT DEFAULT 0,
    [Precisions] VARCHAR(70) ,
    [Consolider] BIT DEFAULT 0,
    [Affectation] VARCHAR(50) ,
    [NumRetour] VARCHAR(20) );
CREATE INDEX [WDIDX_Flux_RefFlux] ON [Flux] ([RefFlux]);
CREATE INDEX [WDIDX_Flux_Processus] ON [Flux] ([Processus]);
CREATE INDEX [WDIDX_Flux_Magasin] ON [Flux] ([Magasin]);
CREATE INDEX [WDIDX_Flux_CodeChantier] ON [Flux] ([CodeChantier]);
CREATE INDEX [WDIDX_Flux_NumTransfert] ON [Flux] ([NumTransfert]);
CREATE INDEX [WDIDX_Flux_DateOperation] ON [Flux] ([DateOperation]);
CREATE INDEX [WDIDX_Flux_NumLivraison] ON [Flux] ([NumLivraison]);
CREATE INDEX [WDIDX_Flux_NumReception] ON [Flux] ([NumReception]);
CREATE INDEX [WDIDX_Flux_NumCommande] ON [Flux] ([NumCommande]);
CREATE INDEX [WDIDX_Flux_ImputationAnalyt] ON [Flux] ([ImputationAnalyt]);
CREATE INDEX [WDIDX_Flux_NumSortie] ON [Flux] ([NumSortie]);
CREATE INDEX [WDIDX_Flux_CodeArticle] ON [Flux] ([CodeArticle]);
CREATE INDEX [WDIDX_Flux_Consolider] ON [Flux] ([Consolider]);
CREATE INDEX [WDIDX_Flux_Affectation] ON [Flux] ([Affectation]);
CREATE INDEX [WDIDX_Flux_NumRetour] ON [Flux] ([NumRetour]);
CREATE INDEX [WDIDX_Flux_NumTransfertRefFlux] ON [Flux] ([NumTransfert],[RefFlux]);
CREATE INDEX [WDIDX_Flux_NumReceptionRefFlux] ON [Flux] ([NumReception],[RefFlux]);
CREATE INDEX [WDIDX_Flux_OptimCleComp_Conso_CodeC] ON [Flux] ([Consolider],[CodeChantier]);
CREATE INDEX [WDIDX_Flux_OptimCleComp_Conso_CodeA] ON [Flux] ([Consolider],[CodeArticle]);
CREATE INDEX [WDIDX_Flux_CodeChantierNumTransfert] ON [Flux] ([CodeChantier],[NumTransfert]);
CREATE INDEX [WDIDX_Flux_CodeChantierNumReception] ON [Flux] ([CodeChantier],[NumReception]);
CREATE INDEX [WDIDX_Flux_CodeChantierNumSortie] ON [Flux] ([CodeChantier],[NumSortie]);
CREATE INDEX [WDIDX_Flux_CodeChantierNumRetour] ON [Flux] ([CodeChantier],[NumRetour]);
CREATE UNIQUE INDEX [WDIDX_Flux_CodeChantierNumTransfertDateOperationNumCommandeNumLivraisonNumReceptionNumSortieNumRetourCodeArticle] ON [Flux] ([CodeChantier],[NumTransfert],[DateOperation],[NumCommande],[NumLivraison],[NumReception],[NumSortie],[NumRetour],[CodeArticle],[Quantite]);

-- Cration de la table Flux_SI
CREATE TABLE [Flux_SI] (
    [IDFlux] INTEGER  IDENTITY   PRIMARY KEY ,
    [RefFlux] VARCHAR(5) ,
    [Processus] SMALLINT DEFAULT 0,
    [Magasin] VARCHAR(50) ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [NumTransfert] VARCHAR(20) ,
    [DateOperation] DATETIME ,
    [NumLivraison] VARCHAR(20) ,
    [NumReception] VARCHAR(20) ,
    [NumCommande] VARCHAR(20) ,
    [ImputationAnalyt] VARCHAR(50) ,
    [NumSortie] VARCHAR(20) ,
    [CodeArticle] VARCHAR(6) ,
    [Quantite] FLOAT DEFAULT 0,
    [Precisions] VARCHAR(70) ,
    [Consolider] BIT DEFAULT 0);
CREATE INDEX [WDIDX_Flux_SI_RefFlux] ON [Flux_SI] ([RefFlux]);
CREATE INDEX [WDIDX_Flux_SI_Processus] ON [Flux_SI] ([Processus]);
CREATE INDEX [WDIDX_Flux_SI_Magasin] ON [Flux_SI] ([Magasin]);
CREATE INDEX [WDIDX_Flux_SI_CodeChantier] ON [Flux_SI] ([CodeChantier]);
CREATE INDEX [WDIDX_Flux_SI_NumTransfert] ON [Flux_SI] ([NumTransfert]);
CREATE INDEX [WDIDX_Flux_SI_DateOperation] ON [Flux_SI] ([DateOperation]);
CREATE INDEX [WDIDX_Flux_SI_NumLivraison] ON [Flux_SI] ([NumLivraison]);
CREATE INDEX [WDIDX_Flux_SI_NumReception] ON [Flux_SI] ([NumReception]);
CREATE INDEX [WDIDX_Flux_SI_NumCommande] ON [Flux_SI] ([NumCommande]);
CREATE INDEX [WDIDX_Flux_SI_ImputationAnalyt] ON [Flux_SI] ([ImputationAnalyt]);
CREATE INDEX [WDIDX_Flux_SI_NumSortie] ON [Flux_SI] ([NumSortie]);
CREATE INDEX [WDIDX_Flux_SI_CodeArticle] ON [Flux_SI] ([CodeArticle]);
CREATE INDEX [WDIDX_Flux_SI_Consolider] ON [Flux_SI] ([Consolider]);
CREATE INDEX [WDIDX_Flux_SI_NumTransfertRefFlux] ON [Flux_SI] ([NumTransfert],[RefFlux]);
CREATE INDEX [WDIDX_Flux_SI_NumReceptionRefFlux] ON [Flux_SI] ([NumReception],[RefFlux]);

-- Cration de la table Formulaires
CREATE TABLE [Formulaires] (
    [IDFormulaires] INTEGER  IDENTITY   PRIMARY KEY ,
    [Stockable] SMALLINT DEFAULT 0,
    [CodeFamille] VARCHAR(2) ,
    [Formulaire] VARCHAR(20) );
CREATE INDEX [WDIDX_Formulaires_Stockable] ON [Formulaires] ([Stockable]);
CREATE INDEX [WDIDX_Formulaires_CodeFamille] ON [Formulaires] ([CodeFamille]);
CREATE UNIQUE INDEX [WDIDX_Formulaires_StockableCodeFamille] ON [Formulaires] ([Stockable],[CodeFamille]);

-- Cration de la table Historiques
CREATE TABLE [Historiques] (
    [IDHistoriques] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [CodeArticle] VARCHAR(6) ,
    [Article] VARCHAR(70) ,
    [AffectationE] VARCHAR(50) ,
    [AffectationR] VARCHAR(50) ,
    [Quantite] FLOAT DEFAULT 0,
    [Annee] DATETIME ,
    [Mois] DATETIME ,
    [DateOperation] DATETIME );
CREATE INDEX [WDIDX_Historiques_CodeChantier] ON [Historiques] ([CodeChantier]);
CREATE INDEX [WDIDX_Historiques_CodeArticle] ON [Historiques] ([CodeArticle]);
CREATE INDEX [WDIDX_Historiques_Article] ON [Historiques] ([Article]);
CREATE INDEX [WDIDX_Historiques_Annee] ON [Historiques] ([Annee]);
CREATE INDEX [WDIDX_Historiques_Mois] ON [Historiques] ([Mois]);
CREATE INDEX [WDIDX_Historiques_DateOperation] ON [Historiques] ([DateOperation]);
CREATE INDEX [WDIDX_Historiques_OptimCleComp_CodeC_DateO] ON [Historiques] ([CodeChantier],[DateOperation]);

-- Cration de la table Imputations
CREATE TABLE [Imputations] (
    [IDImputations] INTEGER  IDENTITY   PRIMARY KEY ,
    [ImputationAnalyt] VARCHAR(50) ,
    [CodeChantier] VARCHAR(50) DEFAULT '0');
CREATE INDEX [WDIDX_Imputations_ImputationAnalyt] ON [Imputations] ([ImputationAnalyt]);
CREATE INDEX [WDIDX_Imputations_CodeChantier] ON [Imputations] ([CodeChantier]);

-- Cration de la table Inventaire_Stock
CREATE TABLE [Inventaire_Stock] (
    [IDInventaire_Stock] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeArticle] VARCHAR(6)  UNIQUE ,
    [Article] VARCHAR(70) ,
    [Mois] DATETIME ,
    [Annee] DATETIME ,
    [QteTheorique] FLOAT DEFAULT 0,
    [QtePhysique] FLOAT DEFAULT 0,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [Affectation] VARCHAR(50) ,
    [CodeFamille] VARCHAR(2) ,
    [Famille] VARCHAR(100) ,
    [CodeSousFamille] VARCHAR(4) ,
    [SousFamille] VARCHAR(100) ,
    [QteMax] REAL DEFAULT 0,
    [QteMin] REAL DEFAULT 0);
CREATE INDEX [WDIDX_Inventaire_Stock_Article] ON [Inventaire_Stock] ([Article]);
CREATE INDEX [WDIDX_Inventaire_Stock_Mois] ON [Inventaire_Stock] ([Mois]);
CREATE INDEX [WDIDX_Inventaire_Stock_Annee] ON [Inventaire_Stock] ([Annee]);
CREATE INDEX [WDIDX_Inventaire_Stock_QteTheorique] ON [Inventaire_Stock] ([QteTheorique]);
CREATE INDEX [WDIDX_Inventaire_Stock_CodeChantier] ON [Inventaire_Stock] ([CodeChantier]);
CREATE INDEX [WDIDX_Inventaire_Stock_Affectation] ON [Inventaire_Stock] ([Affectation]);
CREATE INDEX [WDIDX_Inventaire_Stock_CodeFamille] ON [Inventaire_Stock] ([CodeFamille]);
CREATE INDEX [WDIDX_Inventaire_Stock_Famille] ON [Inventaire_Stock] ([Famille]);
CREATE INDEX [WDIDX_Inventaire_Stock_CodeSousFamille] ON [Inventaire_Stock] ([CodeSousFamille]);
CREATE INDEX [WDIDX_Inventaire_Stock_SousFamille] ON [Inventaire_Stock] ([SousFamille]);

-- Cration de la table Mvts_Stock
CREATE TABLE [Mvts_Stock] (
    [IDMvts_Stock] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeMvts] SMALLINT DEFAULT 0,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [Mois] DATETIME ,
    [Annee] DATETIME ,
    [NumApprov] VARCHAR(20) ,
    [NumTransfert] VARCHAR(20) ,
    [DateOperation] DATETIME ,
    [NumDemandeAch] VARCHAR(20) ,
    [NumCommande] VARCHAR(20) ,
    [NumLivraison] VARCHAR(20) ,
    [NumSortie] VARCHAR(20) ,
    [NumRetour] VARCHAR(20) ,
    [NumReception] VARCHAR(20) ,
    [Magasin] VARCHAR(50) ,
    [Fournisseur] VARCHAR(50) ,
    [NonConforme] BIT DEFAULT 0);
CREATE INDEX [WDIDX_Mvts_Stock_CodeMvts] ON [Mvts_Stock] ([CodeMvts]);
CREATE INDEX [WDIDX_Mvts_Stock_CodeChantier] ON [Mvts_Stock] ([CodeChantier]);
CREATE INDEX [WDIDX_Mvts_Stock_Mois] ON [Mvts_Stock] ([Mois]);
CREATE INDEX [WDIDX_Mvts_Stock_Annee] ON [Mvts_Stock] ([Annee]);
CREATE INDEX [WDIDX_Mvts_Stock_NumApprov] ON [Mvts_Stock] ([NumApprov]);
CREATE INDEX [WDIDX_Mvts_Stock_NumTransfert] ON [Mvts_Stock] ([NumTransfert]);
CREATE INDEX [WDIDX_Mvts_Stock_DateOperation] ON [Mvts_Stock] ([DateOperation]);
CREATE INDEX [WDIDX_Mvts_Stock_NumDemandeAch] ON [Mvts_Stock] ([NumDemandeAch]);
CREATE INDEX [WDIDX_Mvts_Stock_NumCommande] ON [Mvts_Stock] ([NumCommande]);
CREATE INDEX [WDIDX_Mvts_Stock_NumLivraison] ON [Mvts_Stock] ([NumLivraison]);
CREATE INDEX [WDIDX_Mvts_Stock_NumSortie] ON [Mvts_Stock] ([NumSortie]);
CREATE INDEX [WDIDX_Mvts_Stock_NumRetour] ON [Mvts_Stock] ([NumRetour]);
CREATE INDEX [WDIDX_Mvts_Stock_NumReception] ON [Mvts_Stock] ([NumReception]);
CREATE INDEX [WDIDX_Mvts_Stock_Magasin] ON [Mvts_Stock] ([Magasin]);
CREATE INDEX [WDIDX_Mvts_Stock_Fournisseur] ON [Mvts_Stock] ([Fournisseur]);
CREATE INDEX [WDIDX_Mvts_Stock_NonConforme] ON [Mvts_Stock] ([NonConforme]);
CREATE INDEX [WDIDX_Mvts_Stock_CodeMvtsNumRetour] ON [Mvts_Stock] ([CodeMvts],[NumRetour]);

-- Cration de la table Natures
CREATE TABLE [Natures] (
    [IDNatures] INTEGER  IDENTITY   PRIMARY KEY ,
    [Designation] VARCHAR(100) ,
    [CodeNature] VARCHAR(6)  UNIQUE  DEFAULT '0',
    [PheonetiqueDes] VARCHAR(50) );
CREATE INDEX [WDIDX_Natures_Designation] ON [Natures] ([Designation]);
CREATE INDEX [WDIDX_Natures_PheonetiqueDes] ON [Natures] ([PheonetiqueDes]);

-- Cration de la table Periodes
CREATE TABLE [Periodes] (
    [IDPeriodes] INTEGER  IDENTITY   PRIMARY KEY ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [DateDebut] DATETIME ,
    [DateFin] DATETIME ,
    [Cloturer] BIT DEFAULT 0,
    [NomChantier] VARCHAR(70) ,
    [CodeSection] INTEGER DEFAULT 0);
CREATE INDEX [WDIDX_Periodes_CodeChantier] ON [Periodes] ([CodeChantier]);
CREATE INDEX [WDIDX_Periodes_NomChantier] ON [Periodes] ([NomChantier]);
CREATE INDEX [WDIDX_Periodes_CodeSection] ON [Periodes] ([CodeSection]);

-- Cration de la table Regules
CREATE TABLE [Regules] (
    [IDRegules] INTEGER  IDENTITY   PRIMARY KEY ,
    [ReferenceRegule] VARCHAR(50) ,
    [CodeChantier] VARCHAR(50) DEFAULT '0',
    [DateRegule] DATETIME ,
    [CodeArticle] VARCHAR(6) ,
    [Quantite] FLOAT DEFAULT 0,
    [Exporter] BIT DEFAULT 0,
    [IDFlux] INTEGER DEFAULT 0);
CREATE INDEX [WDIDX_Regules_ReferenceRegule] ON [Regules] ([ReferenceRegule]);
CREATE INDEX [WDIDX_Regules_CodeChantier] ON [Regules] ([CodeChantier]);
CREATE INDEX [WDIDX_Regules_CodeArticle] ON [Regules] ([CodeArticle]);
CREATE INDEX [WDIDX_Regules_Exporter] ON [Regules] ([Exporter]);
CREATE INDEX [WDIDX_Regules_IDFlux] ON [Regules] ([IDFlux]);

-- Cration de la table SousFamilles
CREATE TABLE [SousFamilles] (
    [IDSousFamilles] INTEGER  IDENTITY   PRIMARY KEY ,
    [Designation] VARCHAR(100) ,
    [CodeSousFamille] VARCHAR(4)  UNIQUE  DEFAULT '0');
CREATE INDEX [WDIDX_SousFamilles_Designation] ON [SousFamilles] ([Designation]);

-- Cration de la table Systeme
CREATE TABLE [Systeme] (
    [IDSysteme] INTEGER  IDENTITY   PRIMARY KEY ,
    [NumHDD] VARCHAR(50) ,
    [Serveur] VARCHAR(100) ,
    [Login] VARCHAR(50) ,
    [MotPasse] VARCHAR(50) );
CREATE INDEX [WDIDX_Systeme_NumHDD] ON [Systeme] ([NumHDD]);
CREATE INDEX [WDIDX_Systeme_Serveur] ON [Systeme] ([Serveur]);

-- Cration de la table Traces
CREATE TABLE [Traces] (
    [IDTraces] INTEGER  IDENTITY   PRIMARY KEY ,
    [Utilisateur] VARCHAR(50) ,
    [Date] DATETIME ,
    [Heure] DATETIME ,
    [TypeOperation] VARCHAR(50) ,
    [CodeObjet] VARCHAR(10) ,
    [Designation] VARCHAR(100) ,
    [Description] VARCHAR(100) ,
    [StatutObjet] SMALLINT DEFAULT 0,
    [CodeSage] VARCHAR(50) ,
    [Usage] SMALLINT DEFAULT 0,
    [Marque] VARCHAR(50) ,
    [Unite] VARCHAR(50) ,
    [Stockable] SMALLINT DEFAULT 0,
    [AffectComptable] VARCHAR(50) ,
    [Alternatif1] VARCHAR(50) ,
    [Alternatif2] VARCHAR(50) ,
    [Alternatif3] VARCHAR(50) ,
    [CCodeObjet] VARCHAR(10) ,
    [DDesignation] VARCHAR(100) ,
    [DDescription] VARCHAR(100) ,
    [SStatutObjet] SMALLINT DEFAULT 0,
    [CCodeSage] VARCHAR(50) ,
    [UUsage] SMALLINT DEFAULT 0,
    [MMarque] VARCHAR(50) ,
    [UUnite] VARCHAR(50) ,
    [SStockable] SMALLINT DEFAULT 0,
    [AAffectComptable] VARCHAR(50) ,
    [AAlternatif1] VARCHAR(50) ,
    [AAlternatif2] VARCHAR(50) ,
    [AAlternatif3] VARCHAR(50) ,
    [ObjetTrace] VARCHAR(50) );
CREATE INDEX [WDIDX_Traces_Utilisateur] ON [Traces] ([Utilisateur]);
CREATE INDEX [WDIDX_Traces_Date] ON [Traces] ([Date]);
CREATE INDEX [WDIDX_Traces_TypeOperation] ON [Traces] ([TypeOperation]);
CREATE INDEX [WDIDX_Traces_ObjetTrace] ON [Traces] ([ObjetTrace]);

-- Cration de la table Unites
CREATE TABLE [Unites] (
    [IDUnites] INTEGER  IDENTITY   PRIMARY KEY ,
    [Unite] VARCHAR(10) );
CREATE INDEX [WDIDX_Unites_Unite] ON [Unites] ([Unite]);
-- Contraintes d'intgrit
ALTER TABLE [Details_Mvts_Stock] ADD FOREIGN KEY ([IDMvts_Stock]) REFERENCES [Mvts_Stock] ([IDMvts_Stock]);
